/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWFieldUsageDialog;
import filenet.vw.toolkit.design.property.dialog.VWStepItem;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWFieldTableModel;
import filenet.vw.toolkit.design.property.tables.VWAttachmentTableModel;
import filenet.vw.toolkit.design.property.tables.VWFieldTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.dialog.VWFieldNameSelectorDialog;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

abstract class VWBasePropPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWTableActionListener,
IVWPropertyChangeSource {
    protected VWAuthPropertyData m_authPropertyData = null;
    protected VWToolbarBorder m_toolBarBorder = null;
    protected VWTable m_fieldTable = null;
    protected IVWFieldTableModel m_fieldTableModel = null;
    private Vector m_changedItems = null;

    VWBasePropPanel() {
    }

    public void highlightField(String fieldName) {
        int rowIndex = this.findRowIndex(fieldName);
        if (rowIndex != this.m_fieldTable.getSelectedRow()) {
            this.m_fieldTable.clearSelection();
            if (rowIndex != -1) {
                this.m_fieldTable.setRowSelectionInterval(rowIndex, rowIndex);
            }
        }
    }

    public void stopEditing() {
        if (this.m_fieldTable != null) {
            this.m_fieldTable.stopEditing();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_fieldTable.getRowCount() - 1) {
                    nRow = this.m_fieldTable.getRowCount() - 1;
                }
                if (nRow == this.m_fieldTable.getSelectedRow()) {
                    this.m_fieldTable.clearSelection();
                }
                this.m_fieldTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != -1 || this.m_fieldTable.getSelectedRow() != event.getLastRow()) break;
                this.updateToolbarButtonStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateToolbarButtonStates();
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_fieldTable.stopEditing();
            switch (event.getID()) {
                case 256: {
                    this.onInitAttachment(this.m_fieldTable.getSelectedRow());
                    break;
                }
                case 64: {
                    this.m_fieldTableModel.copyItem(this.m_fieldTable.getSelectedRow());
                    this.m_fieldTable.ensureRowIsVisible(this.m_fieldTable.getSelectedRow());
                    break;
                }
                case 0x10000000: {
                    this.m_fieldTableModel.deleteItem(this.m_fieldTable.getSelectedRow());
                    break;
                }
                case 512: {
                    this.onFieldUsage();
                    break;
                }
                case 1024: {
                    this.m_fieldTableModel.sortAscending();
                    break;
                }
                case 1: {
                    this.onUp();
                    break;
                }
                case 2: {
                    this.onDown();
                    break;
                }
                case 4: {
                    this.onExposedFields();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_fieldTable == null) break;
                this.m_fieldTable.stopEditing();
            }
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void init(VWAuthPropertyData authPropertyData, String description, int nFlags) {
        this.m_authPropertyData = authPropertyData;
        this.createControls(description, nFlags);
        this.reinitialize();
        this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
    }

    protected void reinitialize() {
        if (this.m_fieldTableModel != null) {
            this.m_fieldTableModel.reinitialize();
        }
        this.m_fieldTable.clearSelection();
        this.m_fieldTable.setRowSelectionInterval(0, 0);
    }

    protected void createControls(String description, int nFlags) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
            this.m_toolBarBorder = new VWToolbarBorder(description, nFlags);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolBarBorder, "Center");
            this.m_fieldTable = new VWTable(this.m_fieldTableModel);
            this.m_fieldTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_fieldTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_fieldTable.setName("m_fieldTable_VWBasePropPanel");
            this.m_fieldTable.setRowSelectionAllowed(true);
            this.m_fieldTable.getSelectionModel().addListSelectionListener(this);
            this.m_fieldTable.getSelectionModel().setSelectionMode(0);
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_fieldTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onFieldUsage() {
        try {
            int nRowIndex = this.m_fieldTable.getSelectedRow();
            String fieldName = null;
            fieldName = this.m_fieldTableModel instanceof VWAttachmentTableModel ? (String)this.m_fieldTableModel.getValueAt(nRowIndex, this.m_fieldTableModel.getActualColumnIndex(2)) : (String)this.m_fieldTableModel.getValueAt(nRowIndex, this.m_fieldTableModel.getActualColumnIndex(1));
            if (this.m_authPropertyData != null) {
                VWFieldDefinition fieldDef = this.m_authPropertyData.getField(fieldName);
                VWFieldUsageDialog fieldUsageDialog = new VWFieldUsageDialog(this.m_authPropertyData.getMainContainer());
                fieldUsageDialog.init(this.m_authPropertyData, fieldDef);
                if (fieldUsageDialog.hasMaps()) {
                    fieldUsageDialog.setVisible(true);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noAvailableWritableMaps, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onUp() {
    }

    protected void onDown() {
    }

    protected void onExposedFields() {
        try {
            int rowCount = this.m_fieldTable.getRowCount();
            Vector<VWFieldDefinition> names = new Vector<VWFieldDefinition>();
            for (int nIndex = 0; nIndex < rowCount; ++nIndex) {
                VWFieldDefinition fieldDef = ((VWFieldTableModel)this.m_fieldTableModel).getItemAt(nIndex);
                if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0) continue;
                names.addElement(fieldDef);
            }
            VWSystemConfiguration sysConfig = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getSystemConfiguration();
            VWFieldNameSelectorDialog dlg = new VWFieldNameSelectorDialog(this.m_authPropertyData.getMainContainer(), sysConfig, names, false);
            dlg.setVisible(true);
            if (!dlg.getStatus()) {
                Object[] selected_items = dlg.getSelectedDataFields();
                Object[] available_items = dlg.getAvailableDataFields();
                rowCount = this.m_fieldTable.getRowCount();
                for (int nIndex = rowCount - 1; nIndex >= 0; --nIndex) {
                    VWFieldDefinition fieldDef = ((VWFieldTableModel)this.m_fieldTableModel).getItemAt(nIndex);
                    if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0 || this.isInList(fieldDef, selected_items) || !this.isInList(fieldDef, available_items)) continue;
                    this.m_fieldTableModel.deleteItem(nIndex);
                }
                for (int i = 0; i < selected_items.length; ++i) {
                    boolean found = false;
                    VWDataFieldItem item = (VWDataFieldItem)selected_items[i];
                    rowCount = this.m_fieldTable.getRowCount();
                    for (int nIndex = 0; nIndex < rowCount; ++nIndex) {
                        VWFieldDefinition fieldDef = ((VWFieldTableModel)this.m_fieldTableModel).getItemAt(nIndex);
                        if (fieldDef == null || VWStringUtils.compare(fieldDef.getName(), "") == 0 || item == null || VWStringUtils.compare(fieldDef.getName(), item.getName()) != 0) continue;
                        switch (item.getType()) {
                            default: 
                        }
                        if (fieldDef.getFieldType() != item.getType()) continue;
                        found = true;
                    }
                    if (found) continue;
                    this.m_fieldTableModel.addItem(rowCount - 1, selected_items[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_toolBarBorder = null;
        }
        if (this.m_fieldTable != null) {
            this.m_fieldTable.getSelectionModel().removeListSelectionListener(this);
            this.m_fieldTable = null;
        }
        if (this.m_fieldTableModel != null) {
            this.m_fieldTableModel.removeTableModelListener(this);
            this.m_fieldTableModel = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private boolean isInList(VWFieldDefinition fieldDef, Object[] lists) {
        if (lists != null) {
            for (int i = 0; i < lists.length; ++i) {
                VWDataFieldItem item;
                if (!(lists[i] instanceof VWDataFieldItem) || (item = (VWDataFieldItem)lists[i]) == null || VWStringUtils.compare(fieldDef.getName(), item.getName()) != 0 || fieldDef.getFieldType() != item.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private void onInitAttachment(int rowIndex) {
        block9: {
            VWParameterDefinition parameterDef = null;
            try {
                if (this.m_authPropertyData == null || this.m_authPropertyData.getWorkflowDefinition() == null) break block9;
                int stepsButtonStatus = this.m_toolBarBorder.getControlStatus(256);
                if ((stepsButtonStatus & 4) != 0) {
                    String name = (String)this.m_fieldTableModel.getValueAt(rowIndex, this.m_fieldTableModel.getActualColumnIndex(2));
                    if (name != null) {
                        VWMapNode launchStepMapNode;
                        VWMapDefinition mainMapDef;
                        name = '\"' + name + '\"';
                        VWWorkflowDefinition workflowDef = this.m_authPropertyData.getWorkflowDefinition();
                        workflowDef.setMainAttachmentName(name);
                        VWAttachmentTableModel attachmentTableModel = (VWAttachmentTableModel)this.m_fieldTableModel;
                        VWFieldDefinition fieldDef = attachmentTableModel.getItemAt(rowIndex);
                        if (fieldDef != null && (mainMapDef = this.m_authPropertyData.getMapDefinition("Workflow")) != null && (launchStepMapNode = mainMapDef.getStartStep()) != null) {
                            VWStepDefinition launchStep = (VWStepDefinition)launchStepMapNode;
                            try {
                                parameterDef = launchStep.getParameterDefinition(fieldDef.getName());
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            if (parameterDef == null) {
                                parameterDef = launchStep.createParameter(fieldDef.getName(), 3, fieldDef.getName(), fieldDef.getFieldType(), fieldDef.isArray());
                                parameterDef.setDescription(fieldDef.getDescription());
                            }
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(new VWStepItem(launchStep.getName(), launchStepMapNode));
                            this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 553);
                        }
                    }
                } else {
                    this.m_authPropertyData.getWorkflowDefinition().setMainAttachmentName(null);
                }
                this.m_fieldTable.clearSelection();
                this.m_fieldTable.setRowSelectionInterval(rowIndex, rowIndex);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 8, 256));
            }
        }
    }

    private int findRowIndex(String fieldName) {
        int nRowIndex = 0;
        if (fieldName != null) {
            nRowIndex = this.m_fieldTableModel.findIndex(fieldName);
        }
        return nRowIndex;
    }

    private void updateToolbarButtonStates() {
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 8, 256));
        int nRowCount = -1;
        if (this.m_fieldTable != null && this.m_fieldTableModel != null) {
            nRowCount = this.m_fieldTableModel.getRowCount();
            int nRowIndex = this.m_fieldTable.getSelectedRow();
            if (nRowIndex != -1 && nRowIndex != nRowCount - 1) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (!this.m_fieldTableModel.canDeleteRow(nRowIndex)) {
                    this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
                }
                if (this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                    String name;
                    if (this.m_fieldTableModel instanceof VWAttachmentTableModel && (name = this.m_authPropertyData.getWorkflowDefinition().getMainAttachmentName()) != null && name.equals('\"' + (String)this.m_fieldTableModel.getValueAt(nRowIndex, this.m_fieldTableModel.getActualColumnIndex(2)) + '\"')) {
                        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 4, 256));
                    }
                    if (nRowIndex == 0) {
                        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 1));
                    }
                    if (nRowIndex == nRowCount - 2) {
                        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 2));
                    }
                }
            }
        }
        this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 4));
        if (nRowCount > 1) {
            this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 1024));
        }
    }
}

